# RGD Prototype (Ghana Registrar-General Department)

A self-contained demo that simulates end-to-end company registration: public application → back-office review (Intake → Registrar → Authorization → Finance) → approval with certificate. Uses PHP + SQLite and runs in XAMPP.

## Quick Start

1. Copy this folder to your XAMPP docroot if not already: `c:/xampp/htdocs/orc-app/rgd-prototype/`
2. Start Apache in XAMPP.
3. In your browser open: `http://localhost/orc-app/rgd-prototype/install.php` to initialize the database and seed users.
4. Home: `http://localhost/orc-app/rgd-prototype/`

## Credentials (seeded)

- Admin: `admin / password`
- Intake: `intake / password`
- Registrar: `registrar / password`
- Authorizer: `authorizer / password`
- Finance: `finance / password`

## Demo Script (Suggested)

1. Public Portal → Start new application (`public/index.php` → `apply.php`).
   - Pick a company type. Enter sample applicant details.
   - Upload any files for required documents.
   - Submit to get a tracking number.
2. Back Office → Login as Intake (`backoffice/login.php`).
   - Open Intake Queue, start review, then send to Registrar.
3. Login as Registrar.
   - Start review, then send to Authorizer.
4. Login as Authorizer.
   - Authorize (this unlocks payment for applicant).
5. Public Portal → Track with the same tracking number.
   - Click "Pay Now" and simulate payment.
6. Back Office → Login as Finance.
   - Mark payment confirmed, then Approve & Issue Certificate.
7. Public Portal → Track again and download the certificate.

## Data and Files

- Database: `rgd-prototype/data/proto.db` (SQLite)
- Uploads: `rgd-prototype/uploads/`

## Configuration

- Fees and required docs per company type are set in `lib/util.php`.
- Status flow helpers are in `lib/workflow.php`.
- Simple session-based auth in `lib/auth.php`.

## Notes

- This is a prototype; integrations (payments, SMS/email, national registries) are simulated.
- You can add more seed data in `install.php` or via the Public Portal.
