<?php
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
require_once __DIR__ . '/../lib/workflow.php';
$u = auth_user(); if(!$u){ header('Location: login.php'); exit; }
$brand = brand();
$id = (int)($_GET['id'] ?? 0);
$app = db_fetch('SELECT * FROM applications WHERE id=?',[$id]);
if(!$app){ http_response_code(404); echo 'Not found'; exit; }
$docs = db_fetch_all('SELECT * FROM app_docs WHERE app_id=?',[$id]);
$history = db_fetch_all('SELECT * FROM status_history WHERE app_id=? ORDER BY id ASC',[$id]);
$payments = db_fetch_all('SELECT * FROM payments WHERE app_id=? ORDER BY id DESC',[$id]);
$msgs = db_fetch_all('SELECT * FROM messages WHERE app_id=? ORDER BY id DESC',[$id]);
$extra = json_decode($app['extra_json'] ?? '{}', true) ?: [];
$geo = $extra['geo'] ?? null;
$docTexts = $extra['doc_texts'] ?? [];
$company = $extra['company_details'] ?? [];
$role = $u['role'];
$allowed = ['ADMIN','INTAKE','REGISTRAR','AUTHORIZER','FINANCE'];
if(!in_array($role,$allowed)){ http_response_code(403); echo 'Forbidden'; exit; }

$action_msg = '';
if ($_SERVER['REQUEST_METHOD']==='POST'){
  $act = $_POST['action'] ?? '';
  $autoNext = false;
  if ($act==='start_intake' && ($role==='ADMIN' || $role==='INTAKE') && $app['status']==='SUBMITTED'){
    set_status($id,'INTAKE_REVIEW','Intake review started', $u['id']);
  }
  if ($act==='send_to_registrar' && ($role==='ADMIN' || $role==='INTAKE') && in_array($app['status'],['SUBMITTED','INTAKE_REVIEW'])){
    set_status($id,'FOR_REGISTRAR','Forwarded to Registrar', $u['id']);
    if($role!=='ADMIN') $autoNext = true;
  }
  if ($act==='start_registrar' && ($role==='ADMIN' || $role==='REGISTRAR') && $app['status']==='FOR_REGISTRAR'){
    set_status($id,'REGISTRAR_REVIEW','Registrar review started', $u['id']);
  }
  if ($act==='send_to_authorizer' && ($role==='ADMIN' || $role==='REGISTRAR') && in_array($app['status'],['FOR_REGISTRAR','REGISTRAR_REVIEW'])){
    set_status($id,'FOR_AUTHORIZATION','Forwarded to Authorizer', $u['id']);
    if($role!=='ADMIN') $autoNext = true;
  }
  if ($act==='authorize' && ($role==='ADMIN' || $role==='AUTHORIZER') && $app['status']==='FOR_AUTHORIZATION'){
    set_status($id,'AUTHORIZED','Authorized for payment', $u['id']);
    if($role!=='ADMIN') $autoNext = true;
  }
  if ($act==='mark_paid' && ($role==='ADMIN' || $role==='FINANCE') && $app['status']==='AUTHORIZED'){
    $fee = fee_for_type($app['company_type']);
    db_execute('INSERT INTO payments(app_id,method,amount,ref,status,created_at) VALUES(?,?,?,?,?,?)',[$id,'BANK',$fee,'FIN-'.substr($app['tracking_no'],-6),'PAID',now()]);
    set_status($id,'PAYMENT_CONFIRMED','Payment confirmed by Finance', $u['id']);
    if($role!=='ADMIN') $autoNext = true;
  }
  if ($act==='approve' && ($role==='ADMIN' || $role==='FINANCE') && in_array($app['status'],['PAYMENT_CONFIRMED'])){
    set_status($id,'APPROVED','Application approved and certificate issued', $u['id']);
    add_message($id,'OUT','Approval Notice','Your application has been approved. You can now download your certificate from the tracking page.', $u['id']);
    if($role!=='ADMIN') $autoNext = true;
  }
  if ($act==='reject' && in_array($role,['ADMIN','INTAKE','REGISTRAR','AUTHORIZER'])){
    $reason = trim($_POST['reason'] ?? '');
    set_status($id,'REJECTED','Rejected: '.$reason, $u['id']);
    add_message($id,'OUT','Application Rejected','Reason: '.$reason, $u['id']);
    if($role!=='ADMIN') $autoNext = true;
  }
  if ($act==='rfi' && in_array($role,['ADMIN','INTAKE','REGISTRAR','AUTHORIZER'])){
    $msg = trim($_POST['rfi_text'] ?? 'Please provide additional information.');
    set_status($id,'RFI','Requested for Information', $u['id']);
    add_message($id,'OUT','Request for Information',$msg, $u['id']);
    if($role!=='ADMIN') $autoNext = true;
  }
  if ($act==='note'){
    $note = trim($_POST['note_text'] ?? '');
    if($note!==''){ add_status($id,$app['status'],'Internal note: '.$note,$u['id']); }
  }
  if ($act==='send_msg'){
    $subject = trim($_POST['subject'] ?? 'Message from RGD');
    $body = trim($_POST['body'] ?? '');
    if($body!==''){ add_message($id,'OUT',$subject,$body,$u['id']); }
  }
  if ($autoNext && $role!=='ADMIN'){
    $stageByRole = ['INTAKE'=>'intake','REGISTRAR'=>'registrar','AUTHORIZER'=>'authorizer','FINANCE'=>'finance'];
    $statusesMap = [
      'intake'=>['SUBMITTED','INTAKE_REVIEW','RFI'],
      'registrar'=>['FOR_REGISTRAR','REGISTRAR_REVIEW','RFI'],
      'authorizer'=>['FOR_AUTHORIZATION','RFI'],
      'finance'=>['AUTHORIZED','PAYMENT_CONFIRMED']
    ];
    $stage = $stageByRole[$role] ?? null;
    if ($stage && isset($statusesMap[$stage])){
      $in = implode("','", array_map('strval',$statusesMap[$stage]));
      $rows = db_fetch_all("SELECT id FROM applications WHERE status IN ('{$in}') ORDER BY id DESC",[]);
      $nextId = null; foreach($rows as $r){ if((int)$r['id']!==$id){ $nextId=(int)$r['id']; break; } }
      if ($nextId){ header('Location: app.php?id='.$nextId); exit; }
      else { header('Location: queue.php?stage='.$stage); exit; }
    }
  }
  header('Location: app.php?id='.$id); exit;
}
$app = db_fetch('SELECT * FROM applications WHERE id=?',[$id]);
?>
<?php $page_title='Application: '.$app['tracking_no']; $active_menu=($role==='INTAKE'?'intake':($role==='REGISTRAR'?'registrar':($role==='AUTHORIZER'?'authorizer':'finance'))); include __DIR__.'/partials/layout_start.php'; ?>
<div>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Application: <code><?php echo e($app['tracking_no']) ?></code></h3>
    <a class="btn btn-outline-secondary" href="queue.php?stage=<?php echo ($role==='INTAKE'?'intake':($role==='REGISTRAR'?'registrar':($role==='AUTHORIZER'?'authorizer':'finance'))) ?>">Back to Queue</a>
  </div>
  <div class="row g-4">
    <div class="col-lg-8">
      <div class="card mb-3"><div class="card-body">
        <div class="row">
          <div class="col-sm-6">
            <div class="text-muted small">Company</div>
            <div class="h5 mb-0"><?php echo e($app['company_name']) ?></div>
            <div class="text-muted"><?php echo e(company_types()[$app['company_type']] ?? $app['company_type']) ?></div>
          </div>
          <div class="col-sm-3">
            <div class="text-muted small">Status</div>
            <div class="h5 mb-0"><?php echo e(statuses()[$app['status']] ?? $app['status']) ?></div>
          </div>
          <div class="col-sm-3">
            <div class="text-muted small">Created</div>
            <div class="h6 mb-0"><?php echo e($app['created_at']) ?></div>
          </div>
        </div>
      </div></div>

      <div class="card mb-3"><div class="card-body">
        <div class="h6 mb-2">Applicant & Location</div>
        <div class="row small">
          <div class="col-md-6">
            <div><span class="text-muted">Applicant:</span> <?php echo e($app['applicant_name']) ?></div>
            <div><span class="text-muted">Email:</span> <?php echo e($app['applicant_email']) ?></div>
            <div><span class="text-muted">Phone:</span> <?php echo e($app['phone']) ?></div>
          </div>
          <div class="col-md-6">
            <div><span class="text-muted">Address:</span> <?php echo nl2br(e($app['address'])) ?></div>
            <?php if($geo && ($geo['lat']??'') && ($geo['lng']??'')): ?>
              <div><span class="text-muted">Location:</span> <?php echo e($geo['name'] ?? (($geo['lat']??'').',' .($geo['lng']??''))) ?></div>
              <div><a class="small" target="_blank" href="https://www.google.com/maps?q=<?php echo urlencode(($geo['lat']??'').','.( $geo['lng']??'')) ?>">Open in Maps</a></div>
            <?php endif; ?>
          </div>
        </div>
      </div></div>

      <div class="card mb-3"><div class="card-body">
        <div class="h6 mb-2">Company Details</div>
        <div class="row small">
          <div class="col-md-6">
            <div><span class="text-muted">Registered Office:</span> <?php echo nl2br(e($company['registered_office'] ?? '')) ?></div>
            <div><span class="text-muted">Postal Address:</span> <?php echo e($company['postal_address'] ?? '') ?></div>
            <div><span class="text-muted">Company TIN:</span> <?php echo e($company['company_tin'] ?? '') ?></div>
            <div><span class="text-muted">Website:</span> <?php echo e($company['website'] ?? '') ?></div>
            <div><span class="text-muted">Activity:</span> <?php echo nl2br(e($company['activity'] ?? '')) ?></div>
          </div>
          <div class="col-md-6">
            <?php if(!empty($company['isic_code']) || !empty($company['isic_desc'])): ?>
              <div class="fw-semibold mt-2">Industrial Classification</div>
              <div><span class="text-muted">ISIC Code:</span> <?php echo e($company['isic_code'] ?? '') ?></div>
              <div><span class="text-muted">ISIC Description:</span> <?php echo e($company['isic_desc'] ?? '') ?></div>
              <div><span class="text-muted">Primary:</span> <?php echo e($company['isic_primary'] ?? '') ?></div>
            <?php endif; ?>
            <?php if(!empty($company['sec_name']) || !empty($company['auditor_name'])): ?>
              <div class="fw-semibold mt-2">Officers</div>
              <div><span class="text-muted">Secretary:</span> <?php echo e($company['sec_name'] ?? '') ?> — <?php echo e($company['sec_address'] ?? '') ?></div>
              <div><span class="text-muted">Auditor:</span> <?php echo e($company['auditor_name'] ?? '') ?> (TIN: <?php echo e($company['auditor_tin'] ?? '') ?>, Reg: <?php echo e($company['auditor_reg_no'] ?? '') ?>) — <?php echo e($company['auditor_address'] ?? '') ?></div>
            <?php endif; ?>
            <?php if(!empty($company['capital_currency']) || !empty($company['authorized_shares']) || !empty($company['stated_capital_amount'])): ?>
              <div class="fw-semibold mt-2">Capital</div>
              <div><span class="text-muted">Currency:</span> <?php echo e($company['capital_currency'] ?? '') ?></div>
              <div><span class="text-muted">Authorized Shares:</span> <?php echo e($company['authorized_shares'] ?? '') ?></div>
              <div><span class="text-muted">Stated Capital:</span> <?php echo e($company['stated_capital_amount'] ?? '') ?></div>
              <div><span class="text-muted">Issued Shares:</span> <?php echo e($company['issued_shares'] ?? '') ?></div>
            <?php endif; ?>
          </div>
        </div>
      </div></div>

      <div class="card mb-3"><div class="card-body">
        <div class="h6 mb-2">People</div>
        <?php $dirs = $extra['directors'] ?? []; $owners = $extra['owners'] ?? []; ?>
        <?php if($dirs): ?>
          <div class="fw-semibold small mb-1">Directors</div>
          <div class="table-responsive"><table class="table table-sm">
            <thead><tr><th>Name</th><th>ID/TIN</th><th>Nationality</th><th>DOB</th><th>POB</th><th>Positions</th><th>Phone</th><th>Email</th></tr></thead>
            <tbody>
              <?php foreach($dirs as $d): ?>
                <tr>
                  <td><?php echo e($d['name'] ?? '') ?></td>
                  <td><?php echo e($d['id'] ?? '') ?></td>
                  <td><?php echo e($d['nat'] ?? '') ?></td>
                  <td><?php echo e($d['dob'] ?? '') ?></td>
                  <td><?php echo e($d['pob'] ?? '') ?></td>
                  <td><?php echo e($d['positions'] ?? '') ?></td>
                  <td><?php echo e($d['phone'] ?? '') ?></td>
                  <td><?php echo e($d['email'] ?? '') ?></td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table></div>
        <?php endif; ?>
        <?php if($owners): ?>
          <div class="fw-semibold small mt-3 mb-1">Shareholders</div>
          <div class="table-responsive"><table class="table table-sm">
            <thead><tr><th>Name</th><th>ID/TIN</th><th>Nationality</th><th>DOB</th><th>POB</th><th>% Ownership</th></tr></thead>
            <tbody>
              <?php foreach($owners as $o): ?>
                <tr>
                  <td><?php echo e($o['name'] ?? '') ?></td>
                  <td><?php echo e($o['id'] ?? '') ?></td>
                  <td><?php echo e($o['nat'] ?? '') ?></td>
                  <td><?php echo e($o['dob'] ?? '') ?></td>
                  <td><?php echo e($o['pob'] ?? '') ?></td>
                  <td><?php echo e($o['percent'] ?? '') ?></td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table></div>
        <?php endif; ?>
        <?php if(!$dirs && !$owners): ?><div class="text-muted small">No directors or shareholders captured.</div><?php endif; ?>
      </div></div>

      <div class="card mb-3"><div class="card-body">
        <div class="h6 mb-3">Documents</div>
        <ul class="list-group list-group-flush">
          <?php foreach($docs as $d): ?>
            <li class="list-group-item d-flex justify-content-between align-items-center">
              <span><?php echo e(doc_labels()[$d['doc_key']] ?? $d['doc_key']) ?></span>
              <a class="btn btn-sm btn-outline-primary" target="_blank" href="../uploads/<?php echo rawurlencode($d['file_name']) ?>">View</a>
            </li>
          <?php endforeach; ?>
          <?php if(!$docs): ?><li class="list-group-item text-muted">No uploaded documents.</li><?php endif; ?>
        </ul>
        <?php if($docTexts): ?>
          <div class="h6 mt-3 mb-2">Provided Details</div>
          <ul class="list-group list-group-flush">
            <?php foreach($docTexts as $k=>$val): ?>
              <li class="list-group-item">
                <div class="fw-semibold small"><?php echo e(doc_labels()[$k] ?? $k) ?></div>
                <div class="small"><?php echo nl2br(e($val)) ?></div>
              </li>
            <?php endforeach; ?>
          </ul>
        <?php endif; ?>
      </div></div>

      <div class="card mb-3"><div class="card-body">
        <div class="h6 mb-3">Timeline</div>
        <ul class="list-group list-group-flush">
          <?php foreach($history as $h): ?>
            <li class="list-group-item">
              <div class="fw-semibold"><?php echo e(statuses()[$h['status']] ?? $h['status']) ?></div>
              <div class="small text-muted"><?php echo e($h['created_at']) ?></div>
              <?php if($h['note']): ?><div class="small"><?php echo e($h['note']) ?></div><?php endif; ?>
            </li>
          <?php endforeach; ?>
        </ul>
      </div></div>

      <div class="card mb-3"><div class="card-body">
        <div class="h6 mb-3">Messages</div>
        <?php foreach($msgs as $m): ?>
          <div class="border rounded p-2 mb-2">
            <div class="d-flex justify-content-between">
              <div class="fw-semibold"><?php echo e($m['subject']) ?></div>
              <div class="small text-muted"><?php echo e($m['created_at']) ?></div>
            </div>
            <div class="small text-muted"><?php echo e($m['direction']==='OUT'?'To Applicant':'From Applicant') ?></div>
            <div><?php echo nl2br(e($m['body'])) ?></div>
          </div>
        <?php endforeach; ?>
        <?php if(!$msgs): ?><div class="text-muted">No messages yet.</div><?php endif; ?>
        <form class="mt-3" method="post">
          <input type="hidden" name="action" value="send_msg">
          <div class="row g-2">
            <div class="col-md-4"><input name="subject" class="form-control" placeholder="Subject" value="Message from RGD"></div>
            <div class="col-md-6"><input name="body" class="form-control" placeholder="Type a message"></div>
            <div class="col-md-2"><button class="btn btn-outline-primary w-100">Send</button></div>
          </div>
        </form>
      </div></div>

      <div class="card mb-3"><div class="card-body">
        <div class="h6 mb-3">Internal Note</div>
        <form method="post" class="d-flex gap-2">
          <input type="hidden" name="action" value="note">
          <input name="note_text" class="form-control" placeholder="Add a note">
          <button class="btn btn-outline-secondary">Add</button>
        </form>
      </div></div>
    </div>

    <div class="col-lg-4">
      <div class="card mb-3"><div class="card-body">
        <div class="h6 mb-3">Actions</div>
        <?php if(($role==='ADMIN' || $role==='INTAKE') && $app['status']==='SUBMITTED'): ?>
          <form method="post" class="mb-2"><input type="hidden" name="action" value="start_intake"><button class="btn btn-sm btn-primary w-100">Start Intake Review</button></form>
          <form method="post" class="mb-2"><input type="hidden" name="action" value="send_to_registrar"><button class="btn btn-sm btn-outline-primary w-100">Send to Registrar</button></form>
        <?php endif; ?>
        <?php if(($role==='ADMIN' || $role==='INTAKE') && $app['status']==='INTAKE_REVIEW'): ?>
          <form method="post" class="mb-2"><input type="hidden" name="action" value="send_to_registrar"><button class="btn btn-sm btn-primary w-100">Complete Intake & Send to Registrar</button></form>
        <?php endif; ?>

        <?php if(($role==='ADMIN' || $role==='REGISTRAR') && in_array($app['status'],['FOR_REGISTRAR','RFI'])): ?>
          <form method="post" class="mb-2"><input type="hidden" name="action" value="start_registrar"><button class="btn btn-sm btn-warning w-100">Start Registrar Review</button></form>
        <?php endif; ?>
        <?php if(($role==='ADMIN' || $role==='REGISTRAR') && in_array($app['status'],['FOR_REGISTRAR','REGISTRAR_REVIEW','RFI'])): ?>
          <form method="post" class="mb-2"><input type="hidden" name="action" value="send_to_authorizer"><button class="btn btn-sm btn-outline-warning w-100">Send to Authorizer</button></form>
        <?php endif; ?>

        <?php if(($role==='ADMIN' || $role==='AUTHORIZER') && $app['status']==='FOR_AUTHORIZATION'): ?>
          <form method="post" class="mb-2"><input type="hidden" name="action" value="authorize"><button class="btn btn-sm btn-info w-100">Authorize</button></form>
        <?php endif; ?>

        <?php if(($role==='ADMIN' || $role==='FINANCE') && $app['status']==='AUTHORIZED'): ?>
          <form method="post" class="mb-2"><input type="hidden" name="action" value="mark_paid"><button class="btn btn-sm btn-success w-100">Mark Payment Confirmed</button></form>
        <?php endif; ?>

        <?php if(($role==='ADMIN' || $role==='FINANCE') && in_array($app['status'],['PAYMENT_CONFIRMED'])): ?>
          <form method="post" class="mb-2"><input type="hidden" name="action" value="approve"><button class="btn btn-sm btn-success w-100">Approve & Issue Certificate</button></form>
        <?php endif; ?>

        <?php if(in_array($role,['ADMIN','INTAKE','REGISTRAR','AUTHORIZER']) && !in_array($app['status'],['APPROVED','REJECTED'])): ?>
          <form method="post" class="mb-2">
            <input type="hidden" name="action" value="rfi">
            <div class="input-group input-group-sm">
              <input name="rfi_text" class="form-control" placeholder="Request info message">
              <button class="btn btn-outline-secondary">Send RFI</button>
            </div>
          </form>
          <form method="post" class="mb-2">
            <input type="hidden" name="action" value="reject">
            <div class="input-group input-group-sm">
              <input name="reason" class="form-control" placeholder="Rejection reason">
              <button class="btn btn-outline-danger">Reject</button>
            </div>
          </form>
        <?php endif; ?>

        <?php if($app['status']==='APPROVED'): ?>
          <a class="btn btn-sm btn-outline-success w-100" target="_blank" href="../public/certificate.php?tracking=<?php echo urlencode($app['tracking_no']) ?>">View Certificate</a>
        <?php endif; ?>
      </div></div>

      <div class="card"><div class="card-body">
        <div class="h6 mb-3">Payments</div>
        <?php if(!$payments): ?><div class="text-muted">No payments recorded.</div><?php endif; ?>
        <?php foreach($payments as $p): ?>
          <div class="border rounded p-2 mb-2 small">
            <div>Method: <span class="fw-semibold"><?php echo e($p['method']) ?></span> · Amount: GHS <?php echo e(money($p['amount'])) ?></div>
            <div>Ref: <code><?php echo e($p['ref']) ?></code> · Status: <?php echo e($p['status']) ?> · <?php echo e($p['created_at']) ?></div>
          </div>
        <?php endforeach; ?>
      </div></div>

    </div>
  </div>
</div>
<?php include __DIR__.'/partials/layout_end.php'; ?>
