<?php
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
require_once __DIR__ . '/../lib/config.php';
$u = auth_user(); if(!$u){ header('Location: login.php'); exit; }
if ($u['role']!=='ADMIN'){ http_response_code(403); echo 'Only ADMIN can access settings'; exit; }
$brand = brand();
$msg = '';
$err = '';
if ($_SERVER['REQUEST_METHOD']==='POST'){
  $act = $_POST['action'] ?? '';
  if ($act==='save_brand'){
    config_set('brand_name', trim($_POST['brand_name'] ?? 'Registrar-General Department'));
    $logoUrl = trim($_POST['brand_logo_url'] ?? '');
    if (!empty($_FILES['brand_logo_file']['tmp_name'])){
      $tmp = $_FILES['brand_logo_file']['tmp_name'];
      $name = $_FILES['brand_logo_file']['name'] ?? 'logo';
      $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
      if (!in_array($ext,['png','jpg','jpeg','svg','webp'])){ $ext = 'png'; }
      $dir = realpath(__DIR__ . '/../assets');
      if ($dir===false){ $dir = __DIR__ . '/../assets'; @mkdir($dir,0777,true); }
      $brandDir = $dir.'/brand'; if(!is_dir($brandDir)) @mkdir($brandDir,0777,true);
      $fname = 'logo-'.time().'.'.$ext; $dest = $brandDir.'/'.$fname;
      @move_uploaded_file($tmp,$dest);
      $rel = 'assets/brand/'.$fname;
      $logoUrl = $rel;
    }
    config_set('brand_logo_url', $logoUrl);
    config_set('brand_primary_color', trim($_POST['brand_primary_color'] ?? '#006b3f'));
    $msg = 'Brand settings saved';
  }
  if ($act==='save_notify'){
    config_set('mnotify_api_key', trim($_POST['mnotify_api_key'] ?? ''));
    config_set('mnotify_sender_id', trim($_POST['mnotify_sender_id'] ?? 'RGD'));
    config_set('paystack_public_key', trim($_POST['paystack_public_key'] ?? ''));
    config_set('paystack_secret_key', trim($_POST['paystack_secret_key'] ?? ''));
    config_set('email_mode', trim($_POST['email_mode'] ?? 'log'));
    config_set('smtp_host', trim($_POST['smtp_host'] ?? ''));
    config_set('smtp_port', (int)($_POST['smtp_port'] ?? 587));
    config_set('smtp_username', trim($_POST['smtp_username'] ?? ''));
    config_set('smtp_password', trim($_POST['smtp_password'] ?? ''));
    config_set('smtp_secure', trim($_POST['smtp_secure'] ?? 'tls'));
    config_set('smtp_from_addr', trim($_POST['smtp_from_addr'] ?? 'no-reply@example.com'));
    config_set('smtp_from_name', trim($_POST['smtp_from_name'] ?? 'RGD'));
    $msg = 'Notification settings saved';
  }
  if ($act==='import_csv'){
    if (!empty($_FILES['csv']['tmp_name'])){
      $f = fopen($_FILES['csv']['tmp_name'], 'r');
      if ($f){
        $header = fgetcsv($f);
        $idx = array_flip(array_map('strtolower',$header));
        $updated = 0; $created = 0; $typesSeen = [];
        while(($row = fgetcsv($f))!==false){
          $type_key = trim($row[$idx['type_key']] ?? ''); if($type_key==='') continue;
          $label = trim($row[$idx['label']] ?? $type_key);
          $fee = (float)($row[$idx['fee']] ?? 0);
          $doc_keys_str = trim($row[$idx['doc_keys']] ?? '');
          $exists = db_fetch('SELECT type_key FROM company_types WHERE type_key=?',[$type_key]);
          if ($exists) { db_execute('UPDATE company_types SET label=?, fee=?, active=1 WHERE type_key=?',[$label,$fee,$type_key]); $updated++; }
          else { db_execute('INSERT INTO company_types(type_key,label,fee,display_order,active) VALUES(?,?,?,?,1)',[$type_key,$label,$fee,0]); $created++; }
          $typesSeen[] = $type_key;
          db_execute('DELETE FROM company_required_docs WHERE type_key=?',[$type_key]);
          if ($doc_keys_str!==''){
            $parts = preg_split('/[|;\n]+/',$doc_keys_str);
            foreach($parts as $dk){
              $dk = trim($dk); if($dk==='') continue;
              db_execute('INSERT INTO company_required_docs(type_key,doc_key) VALUES(?,?)',[$type_key,$dk]);
              // ensure label
              $have = db_fetch('SELECT doc_key FROM doc_catalog WHERE doc_key=?',[$dk]);
              if(!$have){ db_execute('INSERT INTO doc_catalog(doc_key,label) VALUES(?,?)',[$dk,$dk]); }
            }
          }
        }
        fclose($f);
        $msg = "Imported CSV. Created: $created, Updated: $updated.";
      } else {
        $err = 'Could not read CSV file';
      }
    } else {
      $err = 'No CSV file uploaded';
    }
  }
  $brand = brand();
}
$types = db_fetch_all('SELECT * FROM company_types ORDER BY display_order, label',[]);
?>
<?php $page_title='Settings'; $active_menu='settings'; include __DIR__.'/partials/layout_start.php'; ?>
<div>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Settings</h3>
    <a class="btn btn-outline-secondary" href="index.php">Back</a>
  </div>
  <?php if($msg): ?><div class="alert alert-success py-2"><?php echo e($msg) ?></div><?php endif; ?>
  <?php if($err): ?><div class="alert alert-danger py-2"><?php echo e($err) ?></div><?php endif; ?>

  <div class="row g-4">
    <div class="col-lg-6">
      <div class="card shadow-sm"><div class="card-body">
        <div class="h5 mb-3">Branding</div>
        <form method="post" enctype="multipart/form-data">
          <input type="hidden" name="action" value="save_brand">
          <div class="mb-3"><label class="form-label">Name</label><input name="brand_name" class="form-control" value="<?php echo e($brand['name']) ?>"></div>
          <div class="mb-3">
            <label class="form-label">Logo Image</label>
            <input type="file" name="brand_logo_file" class="form-control" accept=".png,.jpg,.jpeg,.svg,.webp">
            <div class="form-text">You can also paste a URL below if you prefer.</div>
            <input name="brand_logo_url" class="form-control mt-1" value="<?php echo e($brand['logo']) ?>" placeholder="https://... or assets/brand/logo.png">
            <?php if($brand['logo']): ?>
              <div class="mt-2"><img src="<?php echo e($brand['logo']) ?>" alt="Logo" style="max-height:60px"></div>
            <?php endif; ?>
          </div>
          <div class="mb-3"><label class="form-label">Primary Color</label><input name="brand_primary_color" class="form-control" value="<?php echo e($brand['color']) ?>" placeholder="#006b3f"></div>
          <button class="btn btn-primary">Save</button>
        </form>
      </div></div>
    </div>
    <div class="col-lg-6">
      <div class="card shadow-sm"><div class="card-body">
        <div class="h5 mb-3">Notifications</div>
        <form method="post">
          <input type="hidden" name="action" value="save_notify">
          <div class="row g-2">
            <div class="col-md-8"><label class="form-label">mNotify API Key</label><input name="mnotify_api_key" class="form-control" value="<?php echo e(config_get('mnotify_api_key','')) ?>" autocomplete="off"></div>
            <div class="col-md-4"><label class="form-label">Sender ID</label><input name="mnotify_sender_id" class="form-control" value="<?php echo e(config_get('mnotify_sender_id','RGD')) ?>" maxlength="11"></div>
            <div class="col-md-6"><label class="form-label">Paystack Public Key</label><input name="paystack_public_key" class="form-control" value="<?php echo e(config_get('paystack_public_key','')) ?>" autocomplete="off"></div>
            <div class="col-md-6"><label class="form-label">Paystack Secret Key</label><input type="password" name="paystack_secret_key" class="form-control" value="<?php echo e(config_get('paystack_secret_key','')) ?>" autocomplete="off"></div>
            <div class="col-md-4"><label class="form-label">Email Mode</label><select name="email_mode" class="form-select"><option value="log" <?php echo config_get('email_mode','log')==='log'?'selected':''; ?>>Log Only</option><option value="mail" <?php echo config_get('email_mode','log')==='mail'?'selected':''; ?>>PHP mail()</option></select></div>
            <div class="col-md-4"><label class="form-label">SMTP Host</label><input name="smtp_host" class="form-control" value="<?php echo e(config_get('smtp_host','')) ?>"></div>
            <div class="col-md-4"><label class="form-label">SMTP Port</label><input name="smtp_port" class="form-control" value="<?php echo e(config_get('smtp_port',587)) ?>"></div>
            <div class="col-md-6"><label class="form-label">SMTP Username</label><input name="smtp_username" class="form-control" value="<?php echo e(config_get('smtp_username','')) ?>"></div>
            <div class="col-md-6"><label class="form-label">SMTP Password</label><input type="password" name="smtp_password" class="form-control" value="<?php echo e(config_get('smtp_password','')) ?>" autocomplete="off"></div>
            <div class="col-md-4"><label class="form-label">Secure</label><input name="smtp_secure" class="form-control" value="<?php echo e(config_get('smtp_secure','tls')) ?>"></div>
            <div class="col-md-4"><label class="form-label">From Address</label><input name="smtp_from_addr" class="form-control" value="<?php echo e(config_get('smtp_from_addr','no-reply@example.com')) ?>"></div>
            <div class="col-md-4"><label class="form-label">From Name</label><input name="smtp_from_name" class="form-control" value="<?php echo e(config_get('smtp_from_name','RGD')) ?>"></div>
          </div>
          <button class="btn btn-primary mt-3">Save</button>
        </form>
      </div></div>
    </div>
  </div>

  <div class="card shadow-sm mt-4"><div class="card-body">
    <div class="h5 mb-3">Import Company Types & Requirements (CSV)</div>
    <p class="text-muted">Export your Google Sheet as CSV with headers: <code>type_key,label,fee,doc_keys</code>. Doc keys separated by <code>|</code> or <code>;</code>. Example: <code>RGD_FORM_3B_CLG|CONSTITUTION|DIRECTORS_IDS</code>.</p>
    <form method="post" enctype="multipart/form-data">
      <input type="hidden" name="action" value="import_csv">
      <div class="row g-2 align-items-end">
        <div class="col-md-6">
          <label class="form-label">CSV File</label>
          <input type="file" name="csv" class="form-control" accept=".csv" required>
        </div>
        <div class="col-md-3"><button class="btn btn-success">Import CSV</button></div>
      </div>
    </form>
    <div class="table-responsive mt-3">
      <table class="table table-sm">
        <thead><tr><th>Type Key</th><th>Label</th><th>Fee (GHS)</th><th>Required Docs</th></tr></thead>
        <tbody>
          <?php foreach($types as $t): $docs = db_fetch_all('SELECT d.doc_key, (SELECT label FROM doc_catalog c WHERE c.doc_key=d.doc_key) lbl FROM company_required_docs d WHERE type_key=?',[$t['type_key']]); ?>
            <tr>
              <td><code><?php echo e($t['type_key']) ?></code></td>
              <td><?php echo e($t['label']) ?></td>
              <td><?php echo e(money($t['fee'])) ?></td>
              <td>
                <?php if(!$docs): ?><span class="text-muted">None</span><?php endif; ?>
                <?php foreach($docs as $d): ?>
                  <span class="badge bg-light text-dark border me-1"><?php echo e($d['lbl'] ?: $d['doc_key']) ?></span>
                <?php endforeach; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div></div>
</div>
<?php include __DIR__.'/partials/layout_end.php'; ?>
