<?php
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/util.php';
$pdo = db();
$pdo->exec("CREATE TABLE IF NOT EXISTS settings (key TEXT PRIMARY KEY, value TEXT)");
require_once __DIR__ . '/lib/config.php';
if (config_get('brand_name', null) === null) {
  config_set('brand_name','Registrar-General Department');
  config_set('brand_logo_url','');
  config_set('brand_primary_color','#006b3f');
  config_set('mnotify_api_key','');
  config_set('mnotify_sender_id','RGD');
  config_set('email_mode','log');
  config_set('smtp_host','');
  config_set('smtp_port',587);
  config_set('smtp_username','');
  config_set('smtp_password','');
  config_set('smtp_secure','tls');
  config_set('smtp_from_addr','no-reply@example.com');
  config_set('smtp_from_name','RGD');
}
$pdo->exec("CREATE TABLE IF NOT EXISTS company_types (type_key TEXT PRIMARY KEY, label TEXT, fee REAL, display_order INTEGER DEFAULT 0, active INTEGER DEFAULT 1)");
$pdo->exec("CREATE TABLE IF NOT EXISTS company_required_docs (id INTEGER PRIMARY KEY AUTOINCREMENT, type_key TEXT, doc_key TEXT)");
$pdo->exec("CREATE TABLE IF NOT EXISTS doc_catalog (doc_key TEXT PRIMARY KEY, label TEXT)");
// Seed company types/docs if empty
$hasTypes = db_fetch('SELECT COUNT(*) AS c FROM company_types');
if ((int)($hasTypes['c'] ?? 0) === 0) {
  foreach (company_types() as $k=>$v) {
    db_execute('INSERT INTO company_types(type_key,label,fee,display_order,active) VALUES(?,?,?,?,1)',[$k,$v,fee_for_type($k),0]);
    foreach (required_docs_for_type($k) as $dk) {
      db_execute('INSERT INTO company_required_docs(type_key,doc_key) VALUES(?,?)',[$k,$dk]);
    }
  }
}
// Seed document labels if empty
$hasDocLab = db_fetch('SELECT COUNT(*) AS c FROM doc_catalog');
if ((int)($hasDocLab['c'] ?? 0) === 0) {
  foreach (doc_labels() as $dk=>$lbl) {
    db_execute('INSERT OR IGNORE INTO doc_catalog(doc_key,label) VALUES(?,?)',[$dk,$lbl]);
  }
}
$pdo->exec("CREATE TABLE IF NOT EXISTS users (id INTEGER PRIMARY KEY AUTOINCREMENT, username TEXT UNIQUE, pwd_hash TEXT, name TEXT, role TEXT, created_at TEXT)");
$pdo->exec("CREATE TABLE IF NOT EXISTS applications (id INTEGER PRIMARY KEY AUTOINCREMENT, tracking_no TEXT UNIQUE, company_type TEXT, company_name TEXT, applicant_name TEXT, applicant_email TEXT, phone TEXT, address TEXT, extra_json TEXT, status TEXT, created_at TEXT)");
$pdo->exec("CREATE TABLE IF NOT EXISTS app_docs (id INTEGER PRIMARY KEY AUTOINCREMENT, app_id INTEGER, doc_key TEXT, file_name TEXT, uploaded_at TEXT, FOREIGN KEY(app_id) REFERENCES applications(id) ON DELETE CASCADE)");
$pdo->exec("CREATE TABLE IF NOT EXISTS payments (id INTEGER PRIMARY KEY AUTOINCREMENT, app_id INTEGER, method TEXT, amount REAL, ref TEXT, status TEXT, created_at TEXT, FOREIGN KEY(app_id) REFERENCES applications(id) ON DELETE CASCADE)");
$pdo->exec("CREATE TABLE IF NOT EXISTS status_history (id INTEGER PRIMARY KEY AUTOINCREMENT, app_id INTEGER, status TEXT, note TEXT, user_id INTEGER, created_at TEXT, FOREIGN KEY(app_id) REFERENCES applications(id), FOREIGN KEY(user_id) REFERENCES users(id))");
$pdo->exec("CREATE TABLE IF NOT EXISTS messages (id INTEGER PRIMARY KEY AUTOINCREMENT, app_id INTEGER, direction TEXT, subject TEXT, body TEXT, user_id INTEGER, created_at TEXT, FOREIGN KEY(app_id) REFERENCES applications(id), FOREIGN KEY(user_id) REFERENCES users(id))");
if (!is_dir(__DIR__ . '/uploads')) { @mkdir(__DIR__ . '/uploads', 0777, true); }
$users = db_fetch_all('SELECT * FROM users LIMIT 1');
if (!$users) {
  $seed = [
    ['admin','Administrator','ADMIN'],
    ['intake','Intake Officer','INTAKE'],
    ['registrar','Registrar','REGISTRAR'],
    ['authorizer','Authorizer','AUTHORIZER'],
    ['finance','Finance Officer','FINANCE'],
  ];
  foreach ($seed as $s){
    db_execute('INSERT INTO users(username,pwd_hash,name,role,created_at) VALUES(?,?,?,?,?)',[ $s[0], password_hash('password', PASSWORD_DEFAULT), $s[1], $s[2], now() ]);
  }
}
$apps = db_fetch_all('SELECT id FROM applications LIMIT 1');
if (!$apps) {
  $samples = [
    ['PRIVATE_LIMITED','Akwaaba Foods Ltd','Kofi Mensah','kofi@example.com','0244000001','Accra, Ghana','SUBMITTED'],
    ['SOLE_PROPRIETORSHIP','Sunrise Ventures','Ama Boateng','ama@example.com','0244000002','Kumasi, Ghana','FOR_REGISTRAR'],
    ['PUBLIC_LIMITED','Kente Textiles PLC','Yaw Adjei','yaw@example.com','0244000003','Tamale, Ghana','FOR_AUTHORIZATION'],
    ['NGO','Clean Water Ghana','Efua Abena','efua@example.com','0244000004','Cape Coast, Ghana','AUTHORIZED'],
    ['PARTNERSHIP','Tech Solutions Partners','Kwame Antwi','kwame@example.com','0244000005','Ho, Ghana','APPROVED'],
  ];
  foreach ($samples as $s){
    $tracking = generate_tracking_no();
    db_execute('INSERT INTO applications(tracking_no,company_type,company_name,applicant_name,applicant_email,phone,address,extra_json,status,created_at) VALUES(?,?,?,?,?,?,?,?,?,?)',[
      $tracking,$s[0],$s[1],$s[2],$s[3],$s[4],$s[5],json_encode(['directors'=>''],JSON_UNESCAPED_UNICODE),$s[6],now()
    ]);
    $app_id = db_last_id();
    db_execute('INSERT INTO status_history(app_id,status,note,user_id,created_at) VALUES(?,?,?,?,?)',[$app_id,$s[6],'Seeded status',null,now()]);
    $fee = fee_for_type($s[0]);
    if ($s[6] === 'AUTHORIZED'){
      db_execute('INSERT INTO payments(app_id,method,amount,ref,status,created_at) VALUES(?,?,?,?,?,?)',[$app_id,'MOMO',$fee,'SIM-'.substr($tracking,-6),'PAID',now()]);
      db_execute('UPDATE applications SET status=? WHERE id=?',[ 'PAYMENT_CONFIRMED', $app_id ]);
      db_execute('INSERT INTO status_history(app_id,status,note,user_id,created_at) VALUES(?,?,?,?,?)',[$app_id,'PAYMENT_CONFIRMED','Payment simulated',null,now()]);
    }
    if ($s[6] === 'APPROVED'){
      db_execute('INSERT INTO payments(app_id,method,amount,ref,status,created_at) VALUES(?,?,?,?,?,?)',[$app_id,'BANK',$fee,'SIM-'.substr($tracking,-6),'PAID',now()]);
      db_execute('INSERT INTO status_history(app_id,status,note,user_id,created_at) VALUES(?,?,?,?,?)',[$app_id,'PAYMENT_CONFIRMED','Payment simulated',null,now()]);
    }
  }
}
?><!doctype html><html><head><meta charset="utf-8"><title>Installer</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"></head><body class="p-4">
<div class="container">
  <h1 class="mb-3">RGD Prototype Installer</h1>
  <p>Database initialized. Seed users created with password <code>password</code>.</p>
  <ul>
    <li>Admin: <code>admin/password</code></li>
    <li>Intake: <code>intake/password</code></li>
    <li>Registrar: <code>registrar/password</code></li>
    <li>Authorizer: <code>authorizer/password</code></li>
    <li>Finance: <code>finance/password</code></li>
  </ul>
  <a class="btn btn-primary" href="index.php">Go to Home</a>
</div>
</body></html>
