<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/db.php';
function auth_login($username, $password){
    $u = db_fetch('SELECT * FROM users WHERE username = ?', [$username]);
    if (!$u) return false;
    if (!password_verify($password, $u['pwd_hash'])) return false;
    $_SESSION['user_id'] = $u['id'];
    return true;
}
function auth_user(){
    if (empty($_SESSION['user_id'])) return null;
    return db_fetch('SELECT id,username,name,role FROM users WHERE id = ?', [$_SESSION['user_id']]);
}
function auth_require(){
    if (!auth_user()){
        header('Location: login.php');
        exit;
    }
}
function auth_logout(){ $_SESSION = []; if (ini_get("session.use_cookies")) { $params = session_get_cookie_params(); setcookie(session_name(), '', time() - 42000, $params["path"], $params["domain"], $params["secure"], $params["httponly"]); } session_destroy(); }
function auth_check_role($role){
    $u = auth_user();
    if (!$u) return false;
    if ($u['role'] === 'ADMIN') return true;
    return $u['role'] === $role;
}
?>
