<?php
require_once __DIR__ . '/db.php';
function config_get($key,$default=null){
  $row = db_fetch('SELECT value FROM settings WHERE key=?',[$key]);
  if(!$row) return $default;
  $val = $row['value'];
  $json = json_decode($val,true);
  return $json===null && json_last_error()!==JSON_ERROR_NONE ? $val : $json;
}
function config_set($key,$value){
  $val = is_array($value) || is_object($value) ? json_encode($value, JSON_UNESCAPED_UNICODE) : (string)$value;
  if (db_fetch('SELECT key FROM settings WHERE key=?',[$key])){
    db_execute('UPDATE settings SET value=? WHERE key=?',[$val,$key]);
  } else {
    db_execute('INSERT INTO settings(key,value) VALUES(?,?)',[$key,$val]);
  }
}
function brand(){
  return [
    'name'=>config_get('brand_name','Registrar-General Department'),
    'logo'=>config_get('brand_logo_url',''),
    'color'=>config_get('brand_primary_color','#006b3f')
  ];
}
function mnotify_cfg(){
  return [
    'api_key'=>config_get('mnotify_api_key',''),
    'sender_id'=>config_get('mnotify_sender_id','RGD')
  ];
}
function email_cfg(){
  return [
    'mode'=>config_get('email_mode','log'),
    'host'=>config_get('smtp_host',''),
    'port'=>(int)config_get('smtp_port',587),
    'user'=>config_get('smtp_username',''),
    'pass'=>config_get('smtp_password',''),
    'secure'=>config_get('smtp_secure','tls'),
    'from_addr'=>config_get('smtp_from_addr','no-reply@example.com'),
    'from_name'=>config_get('smtp_from_name','RGD')
  ];
}
function paystack_cfg(){
  return [
    'public_key'=>config_get('paystack_public_key',''),
    'secret_key'=>config_get('paystack_secret_key','')
  ];
}
?>
