<?php
function db() {
    static $pdo = null;
    if ($pdo) return $pdo;
    $dir = __DIR__ . '/../data';
    if (!is_dir($dir)) {
        @mkdir($dir, 0777, true);
    }
    $path = $dir . '/proto.db';
    $pdo = new PDO('sqlite:' . $path);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec('PRAGMA foreign_keys = ON');
    return $pdo;
}
function db_fetch($sql, $params = []) { $stmt = db()->prepare($sql); $stmt->execute($params); return $stmt->fetch(PDO::FETCH_ASSOC); }
function db_fetch_all($sql, $params = []) { $stmt = db()->prepare($sql); $stmt->execute($params); return $stmt->fetchAll(PDO::FETCH_ASSOC); }
function db_execute($sql, $params = []) { $stmt = db()->prepare($sql); return $stmt->execute($params); }
function db_last_id() { return db()->lastInsertId(); }
?>
