<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/config.php';
function e($s){return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');}
function now(){return date('Y-m-d H:i:s');}
function generate_tracking_no(){return 'RGD-'.date('Ymd').'-'.strtoupper(substr(bin2hex(random_bytes(4)),0,6));}
function statuses(){return [
 'SUBMITTED'=>'Submitted',
 'INTAKE_REVIEW'=>'Intake Review',
 'FOR_REGISTRAR'=>'Queued for Registrar',
 'REGISTRAR_REVIEW'=>'Registrar Review',
 'FOR_AUTHORIZATION'=>'Queued for Authorization',
 'AUTHORIZED'=>'Authorized',
 'PAYMENT_CONFIRMED'=>'Payment Confirmed',
 'APPROVED'=>'Approved',
 'REJECTED'=>'Rejected',
 'RFI'=>'Requested for Information'
];}
function roles(){return ['ADMIN','INTAKE','REGISTRAR','AUTHORIZER','FINANCE'];}
function money($n){return number_format((float)$n,2);} 
function company_types(){
 // Try DB first
 try {
   $rows = db_fetch_all("SELECT type_key,label FROM company_types WHERE active=1 ORDER BY display_order, label", []);
   if ($rows && count($rows)>0) { $out=[]; foreach($rows as $r){ $out[$r['type_key']]=$r['label']; } return $out; }
 } catch (Exception $e) {}
 // Fallback defaults
 return [
  'SOLE_PROPRIETORSHIP'=>'Sole Proprietorship',
  'PARTNERSHIP'=>'Partnership',
  'PRIVATE_LIMITED'=>'Private Limited Company',
  'PUBLIC_LIMITED'=>'Public Limited Company',
  'COMPANY_LIMITED_BY_GUARANTEE'=>'Company Limited by Guarantee',
  'EXTERNAL_COMPANY'=>'External Company',
  'NGO'=>'Non-Governmental Organisation'
 ];
}
function doc_labels(){return [
 'ID_DOC'=>'Ghana Card',
 'TIN_DOC'=>'Tax Identification Number Proof',
 'NAME_RESERVATION'=>'Business Name Reservation',
 'CONSTITUTION'=>'Company Constitution/Regulations',
 'PARTNERSHIP_DEED'=>'Partnership Deed',
 'FORM_OF_INCORP'=>'Incorporation Form',
 'DIRECTORS_IDS'=>'Directors IDs',
 'BO_FORM'=>'Beneficial Ownership Form',
 'AUDITOR_CONSENT'=>'Auditor Consent',
 'ADDRESS_PROOF'=>'Office Address Proof',
 'RGD_FORM_3B_CLG'=>'RGD eForm 3B - CLG Registration',
 'RGD_FORM_3_005'=>'RGD Revised Form 3-005',
 'SEC_QUAL'=>'Company Secretary Qualifications',
 'AUD_QUAL'=>'Auditor Qualifications',
 'DIR_STAT_DECL'=>'Statutory Declaration (Director)',
 'DIR_CONSENT'=>'Consent of Director',
 'AUD_CONSENT_DECL'=>'Auditor Consent Declaration'
];}
function doc_link($doc_key){
 $map = [
  'RGD_FORM_3B_CLG' => 'https://www.brr.gov.gh/acc/registry/docs/eForm%203B-CLG-Registration.pdf',
  'RGD_FORM_3_005'  => 'https://www.brr.gov.gh/acc/registry/docs/RGD-Revised%20Form%203-005.pdf'
 ];
 return $map[$doc_key] ?? '';
}
function required_docs_for_type($type){
 $base = ['ID_DOC','TIN_DOC','ADDRESS_PROOF'];
 try {
  $rows = db_fetch_all('SELECT doc_key FROM company_required_docs WHERE type_key=?',[$type]);
  if ($rows && count($rows)>0){
    $list = array_values(array_map(fn($r)=>$r['doc_key'],$rows));
    if ($type==='PRIVATE_LIMITED'){
      $extras = ['CONSTITUTION','FORM_OF_INCORP','DIRECTORS_IDS','BO_FORM','SEC_QUAL','AUD_QUAL','DIR_STAT_DECL','DIR_CONSENT','AUD_CONSENT_DECL'];
      $list = array_values(array_unique(array_merge($base,$list,$extras)));
      // Explicitly remove Business Name Reservation for Private Limited
      $list = array_values(array_diff($list,['NAME_RESERVATION']));
    }
    return $list;
  }
 } catch (Exception $e) {}
 $map = [
  'SOLE_PROPRIETORSHIP'=>array_merge($base,['NAME_RESERVATION']),
  'PARTNERSHIP'=>array_merge($base,['NAME_RESERVATION','PARTNERSHIP_DEED']),
  'PRIVATE_LIMITED'=>array_merge($base,[
    'CONSTITUTION','FORM_OF_INCORP','DIRECTORS_IDS','BO_FORM',
    'SEC_QUAL','AUD_QUAL','DIR_STAT_DECL','DIR_CONSENT','AUD_CONSENT_DECL'
  ]),
 'PUBLIC_LIMITED'=>array_merge($base,['NAME_RESERVATION','CONSTITUTION','FORM_OF_INCORP','DIRECTORS_IDS','BO_FORM','AUDITOR_CONSENT','RGD_FORM_3_005']),
 'COMPANY_LIMITED_BY_GUARANTEE'=>array_merge($base,['NAME_RESERVATION','CONSTITUTION','FORM_OF_INCORP','DIRECTORS_IDS','RGD_FORM_3B_CLG']),
  'EXTERNAL_COMPANY'=>array_merge($base,['CONSTITUTION','FORM_OF_INCORP','DIRECTORS_IDS','ADDRESS_PROOF']),
  'NGO'=>array_merge($base,['NAME_RESERVATION','CONSTITUTION','FORM_OF_INCORP'])
 ];
 return $map[$type] ?? $base;
}
function fee_schedule(){return [
 'SOLE_PROPRIETORSHIP'=>120.00,
 'PARTNERSHIP'=>200.00,
 'PRIVATE_LIMITED'=>550.00,
 'PUBLIC_LIMITED'=>950.00,
 'COMPANY_LIMITED_BY_GUARANTEE'=>300.00,
 'EXTERNAL_COMPANY'=>1200.00,
 'NGO'=>250.00
];}
function fee_for_type($type){
 try {
   $row = db_fetch('SELECT fee FROM company_types WHERE type_key=?',[$type]);
   if ($row && isset($row['fee'])) return (float)$row['fee'];
 } catch (Exception $e) {}
 $f=fee_schedule();return isset($f[$type])?$f[$type]:0.00;
}
function payment_methods(){return ['MOMO'=>'Mobile Money','BANK'=>'Bank Transfer','CARD'=>'Card'];}
function brand_logo_src(){
  $b = brand();
  $src = $b['logo'];
  if(!$src) return '';
  if (preg_match('#^https?://#',$src) || (isset($src[0]) && $src[0]=='/')) return $src;
  $scriptDir = basename(dirname($_SERVER['SCRIPT_NAME'] ?? ''));
  if ($scriptDir==='public' || $scriptDir==='backoffice') return '../'.$src;
  return $src;
}
?>
