<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
require_once __DIR__ . '/../lib/config.php';
session_start();
$tracking = trim($_GET['tracking'] ?? '');
$id = (int)($_GET['id'] ?? 0);
if ($tracking===''){ http_response_code(400); echo 'Missing tracking'; exit; }
$app = db_fetch('SELECT * FROM applications WHERE tracking_no=? AND status=?',[$tracking,'APPROVED']);
if(!$app){ http_response_code(404); echo 'Not found'; exit; }
$otp = $_SESSION['otp'][$tracking] ?? [];
if (!$otp || !($otp['verified'] ?? false) || !($otp['last4_ok'] ?? false)){
  http_response_code(403); echo 'Verification required'; exit;
}
$exp = (int)($_GET['exp'] ?? 0);
$sig = (string)($_GET['sig'] ?? '');
if ($exp < time()){ http_response_code(403); echo 'Link expired'; exit; }
$calc = hash_hmac('sha256', $app['tracking_no'].'|'.$id.'|'.$exp, (string)config_get('download_secret','change-me'));
if (!hash_equals($calc, $sig)){ http_response_code(403); echo 'Invalid signature'; exit; }
$doc = db_fetch('SELECT * FROM app_docs WHERE id=? AND app_id=?',[$id,$app['id']]);
if(!$doc){ http_response_code(404); echo 'Document not found'; exit; }
$path = realpath(__DIR__.'/../uploads/'.$doc['file_name']);
if(!$path || !is_file($path)){ http_response_code(404); echo 'File missing'; exit; }
$ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
$mime = 'application/octet-stream';
$map = [
  'pdf'=>'application/pdf','png'=>'image/png','jpg'=>'image/jpeg','jpeg'=>'image/jpeg','gif'=>'image/gif','webp'=>'image/webp'
];
if(isset($map[$ext])) $mime = $map[$ext];
header('Content-Type: '.$mime);
header('Content-Length: '.filesize($path));
header('Content-Disposition: attachment; filename="'.basename($path).'"');
readfile($path);
