<?php
require_once __DIR__ . '/../lib/util.php';
require_once __DIR__ . '/../lib/config.php';
$brand = brand();
?><!doctype html><html><head><meta charset="utf-8"><title>Public Portal - RGD Prototype</title><meta name="viewport" content="width=device-width,initial-scale=1"><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"><style>:root{--brand: <?php echo e($brand['color']) ?>}
  .hero{background: linear-gradient(180deg, #f8fbf9, #eef3f1);} .btn-brand{background: var(--brand); color:#fff} .btn-brand:hover,.btn-brand:focus,.btn-brand:active{background: var(--brand) !important; color:#fff !important; filter:none; text-decoration:none}
  .glass{backdrop-filter: blur(8px); background: rgba(255,255,255,0.6); border: 1px solid rgba(0,0,0,0.06)}
  .feature{border-radius: 12px}
  .gh-flag{display:flex;height:4px}
  .gh-flag span{flex:1}
  .gh-flag .red{background:#ce1126}
  .gh-flag .gold{background:#fcd116}
  .gh-flag .green{background:#006b3f}
  .faqbot-toggle{position:fixed;right:16px;bottom:16px;z-index:1050;border-radius:999px;width:56px;height:56px;display:flex;align-items:center;justify-content:center;background:var(--brand);color:#fff;border:0;box-shadow:0 6px 20px rgba(0,0,0,.2)}
  .faqbot-toggle:focus{outline:0;box-shadow:0 6px 20px rgba(0,0,0,.25)}
  .faqbot-widget{position:fixed;right:16px;bottom:84px;width:360px;max-width:calc(100vw - 32px);background:#fff;border-radius:16px;box-shadow:0 16px 40px rgba(0,0,0,.2);overflow:hidden;z-index:1050;border:1px solid rgba(0,0,0,.06)}
  .faqbot-header{display:flex;align-items:center;justify-content:space-between;background:var(--brand);color:#fff;padding:10px 12px}
  .faqbot-title{font-weight:600}
  .faqbot-close{background:transparent;border:0;color:#fff;width:32px;height:32px;border-radius:6px}
  .faqbot-body{padding:10px;background:#f8f9fa}
  .faqbot-messages{height:260px;overflow:auto;padding:6px 2px}
  .faqbot-message{display:flex;margin:8px 0}
  .faqbot-message.user{justify-content:flex-end}
  .faqbot-bubble{max-width:80%;padding:10px 12px;border-radius:14px;font-size:.95rem;line-height:1.3}
  .faqbot-message.user .faqbot-bubble{background:var(--brand);color:#fff;border-bottom-right-radius:4px}
  .faqbot-message.bot .faqbot-bubble{background:#fff;border:1px solid rgba(0,0,0,.08);border-bottom-left-radius:4px}
  .faqbot-input{display:flex;gap:8px}
  .faqbot-input input{flex:1}
  .faqbot-chips{display:flex;flex-wrap:wrap;gap:6px;margin-top:6px}
  .faqbot-chip{background:#fff;border:1px solid rgba(0,0,0,.08);border-radius:999px;padding:6px 10px;font-size:.85rem;cursor:pointer}
  .faqbot-chip:hover{background:#f0f3f2}
 </style></head><body class="bg-light">
<nav class="navbar navbar-dark" style="background: var(--brand)"><div class="container">
  <a class="navbar-brand d-flex align-items-center" href="index.php">
    <?php if($brand['logo']): ?><img src="<?php echo e(brand_logo_src()) ?>" alt="Logo" style="height:28px" class="me-2"><?php endif; ?>
    <?php echo e($brand['name']) ?> — Public Portal
  </a>
</div></nav>
<div class="gh-flag"><span class="red"></span><span class="gold"></span><span class="green"></span></div>
<section class="hero py-5">
  <div class="container">
    <div class="row align-items-center g-4">
      <div class="col-lg-7">
        <div class="mb-3">
          <?php if($brand['logo']): ?><img src="<?php echo e(brand_logo_src()) ?>" alt="Logo" style="max-height:56px" class="mb-2"><?php endif; ?>
        </div>
        <h1 class="display-6 fw-bold mb-2">Business Registration Portal</h1>
        <p class="text-muted lead">Register your business, submit documents, track progress, and receive your certificate online.</p>
        <div class="d-flex flex-wrap gap-2 mt-3">
          <a class="btn btn-brand btn-lg" href="apply.php">Start Application</a>
          <a class="btn btn-outline-secondary btn-lg" href="#track">Track Application</a>
        </div>
      </div>
      <div class="col-lg-5">
        <div id="track" class="card shadow glass mb-3">
          <div class="card-body">
            <div class="h5 mb-2">Track your application</div>
            <form action="track.php" method="get">
              <div class="input-group input-group-lg">
                <input required name="tracking" class="form-control" placeholder="e.g. RGD-20251027-ABC123">
                <button class="btn btn-brand" type="submit">Track</button>
              </div>
            </form>
            <div class="small text-muted mt-2">Use the tracking number you received after submission.</div>
          </div>
        </div>
        <div id="retrieve" class="card shadow glass">
          <div class="card-body">
            <div class="h5 mb-2">Retrieve company documents</div>
            <form action="retrieve.php" method="get">
              <div class="input-group input-group-lg">
                <input required name="q" class="form-control" placeholder="Company name or Certificate No. (e.g. CERT-ABC123)">
                <button class="btn btn-brand" type="submit">Search</button>
              </div>
            </form>
            <div class="small text-muted mt-2">Approved companies only. You will verify with an OTP and last 4 digits of TIN/Ghana Card.</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="py-5 bg-white">
  <div class="container">
    <div class="row g-4">
      <div class="col-lg-7">
        <h3 class="mb-3">What you can do here</h3>
        <p class="text-muted">Use this online portal to register your business end-to-end. Start an application, upload your documents, pay securely, track progress, and download your certificate when approved.</p>
        <div class="row g-3 mt-2">
          <div class="col-md-6">
            <div class="p-3 border rounded-3 h-100">
              <div class="fw-semibold">Start a new application</div>
              <div class="small text-muted">Guided forms make it simple to provide your details and entity information.</div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="p-3 border rounded-3 h-100">
              <div class="fw-semibold">Upload supporting documents</div>
              <div class="small text-muted">Submit ID, TIN proof, office address and statutory forms online.</div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="p-3 border rounded-3 h-100">
              <div class="fw-semibold">Secure online payments</div>
              <div class="small text-muted">Pay statutory fees safely via card or mobile money using Paystack.</div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="p-3 border rounded-3 h-100">
              <div class="fw-semibold">Real-time tracking</div>
              <div class="small text-muted">Use your tracking number to follow progress and see every stage.</div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="p-3 border rounded-3 h-100">
              <div class="fw-semibold">Respond to requests</div>
              <div class="small text-muted">Reply online if more information is needed during review.</div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="p-3 border rounded-3 h-100">
              <div class="fw-semibold">Download certificates</div>
              <div class="small text-muted">After approval, download your certificate and statutory documents.</div>
            </div>
          </div>
        </div>

        <h4 class="mt-4">Who can use this portal</h4>
        <ul class="list-unstyled small text-muted mb-0">
          <li class="mb-1">• Entrepreneurs and startups registering a new business</li>
          <li class="mb-1">• Existing businesses formalizing operations</li>
          <li class="mb-1">• NGOs and associations completing statutory registration</li>
        </ul>
      </div>
      <div class="col-lg-5">
        <div class="card shadow-sm mb-3"><div class="card-body">
          <div class="h5 mb-2">How it works</div>
          <ol class="mb-0 small">
            <li>Apply — Provide basic business and applicant details</li>
            <li>Upload — Attach required documents based on your entity type</li>
            <li>Pay — Settle fees securely via Paystack</li>
            <li>Track — Follow progress and respond to requests</li>
            <li>Download — Receive your certificate after approval</li>
          </ol>
        </div></div>
        <div class="card shadow-sm mb-3"><div class="card-body">
          <div class="h5 mb-2">What you’ll need</div>
          <ul class="mb-0 small">
            <li>Valid Government ID</li>
            <li>Tax Identification Number (TIN)</li>
            <li>Registered office address and contact</li>
            <li>Company documents (e.g., constitution, directors’ IDs)</li>
            <li>Payment method (card or mobile money)</li>
          </ul>
        </div></div>
        <div class="card shadow-sm"><div class="card-body">
          <div class="h5 mb-2">Helpful tips</div>
          <ul class="mb-0 small">
            <li>Save your tracking number after submission</li>
            <li>Upload clear document scans for faster processing</li>
            <li>Keep your phone and email active for notifications</li>
          </ul>
        </div></div>
      </div>
    </div>
  </div>
</section>
<section class="py-5">
  <div class="container">
    <div class="row g-3">
      <div class="col-md-4">
        <div class="p-3 border bg-white feature h-100">
          <div class="fw-semibold">Step 1: Apply</div>
          <div class="text-muted">Select company type and provide applicant and company details.</div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="p-3 border bg-white feature h-100">
          <div class="fw-semibold">Step 2: Upload & Review</div>
          <div class="text-muted">Upload required documents. RGD staff review and authorize.</div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="p-3 border bg-white feature h-100">
          <div class="fw-semibold">Step 3: Pay & Download</div>
          <div class="text-muted">Pay fees securely and download your certificate.</div>
        </div>
      </div>
    </div>
    <div class="text-center mt-4"><a href="../index.php" class="link-secondary">Back to Prototype Home</a></div>
  </div>
</section>
 <button id="faqbot-toggle" class="faqbot-toggle" aria-label="Help">
   <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M4 4h16v12H7l-3 3V4z"></path></svg>
 </button>
 <div id="faqbot" class="faqbot-widget d-none" role="dialog" aria-label="FAQ Assistant">
   <div class="faqbot-header"><div class="faqbot-title">Help &amp; FAQ</div><button type="button" class="faqbot-close" aria-label="Close">×</button></div>
   <div class="faqbot-body">
     <div id="faqbot-messages" class="faqbot-messages"></div>
     <div class="faqbot-chips" id="faqbot-chips"></div>
     <div class="faqbot-input input-group mt-2">
       <input id="faqbot-input" class="form-control" placeholder="Ask a question">
       <button id="faqbot-send" class="btn btn-brand" type="button">Send</button>
     </div>
   </div>
 </div>
 <script>
 (function(){
   var t=document.getElementById('faqbot-toggle');
   var w=document.getElementById('faqbot');
   var m=document.getElementById('faqbot-messages');
   var i=document.getElementById('faqbot-input');
   var s=document.getElementById('faqbot-send');
   var c=document.getElementById('faqbot-chips');
   var x=w.querySelector('.faqbot-close');
   var faqs=[
     {q:'How do I start an application?',a:'Click Start Application to begin. You will be guided through each step and can save and continue anytime.',k:['start','apply','application','begin','new']},
     {q:'What documents are required?',a:'You will typically need Ghana Card, TIN, registered office details, and company documents based on entity type. You can upload them during the process.',k:['document','documents','requirements','required','ghana card','id','tin']},
     {q:'How do I pay the fees?',a:'After review, you will be prompted to pay securely via card or mobile money. Payments are processed by Paystack.',k:['pay','payment','fees','fee','card','mobile money','paystack']},
     {q:'How do I track my application?',a:'Use your tracking number on this page in the Track your application box or visit the Track link.',k:['track','tracking','status','progress']},
     {q:'How long does it take?',a:'Processing time varies by application, but many submissions are processed within a few working days after verification and payment.',k:['how long','timeline','duration','time','days']},
     {q:'Which ID is accepted?',a:'Use your Ghana Card when asked for ID.',k:['id','ghana card','national id']},
     {q:'Can I save and continue later?',a:'Yes. Your progress is saved as you go. Return anytime with your tracking number or resume link.',k:['save','continue','later','resume']},
     {q:'I lost my tracking number',a:'Check your email or SMS for the tracking message. If you still cannot find it, contact support with your details.',k:['lost','tracking','number','forgot']},
     {q:'How much are the fees?',a:'Fees depend on your entity type and services selected. You will see the exact amount before payment.',k:['how much','fees','cost','price','amount']},
     {q:'How do I contact support?',a:'Use the contact details provided on the portal or reply to your application emails. Include your tracking number for faster help.',k:['support','help','contact','assist']}
   ];
   function norm(s){return (s||'').toLowerCase().replace(/[^a-z0-9\s]/g,' ').replace(/\s+/g,' ').trim()}
   function add(role,text){var row=document.createElement('div');row.className='faqbot-message '+role;var b=document.createElement('div');b.className='faqbot-bubble';b.textContent=text;row.appendChild(b);m.appendChild(row);m.scrollTop=m.scrollHeight}
   function score(u,item){var sc=0;var n=norm(u);for(var j=0;j<item.k.length;j++){if(n.indexOf(item.k[j])>-1)sc+=2}var nq=norm(item.q);if(n.indexOf(nq)>-1)sc+=3;else{var parts=item.q.toLowerCase().split(/\s+/).filter(function(w){return w.length>3});for(var p=0;p<parts.length;p++){if(n.indexOf(parts[p])>-1)sc+=1}}return sc}
   function answer(q){var best=null,bs=0;for(var idx=0;idx<faqs.length;idx++){var sc=score(q,faqs[idx]);if(sc>bs){bs=sc;best=faqs[idx]}}if(best&&bs>0)return best.a;var sugg=faqs.slice(0,5).map(function(f){return '• '+f.q}).join('  ');return 'I could not find an exact answer. Try one of these: '+sugg}
   function buildChips(){c.innerHTML='';var picks=[faqs[0].q,faqs[1].q,faqs[3].q,faqs[2].q,faqs[8].q];for(var k=0;k<picks.length;k++){var chip=document.createElement('div');chip.className='faqbot-chip';chip.textContent=picks[k];chip.addEventListener('click',function(e){send(e.target.textContent)});c.appendChild(chip)}}
   function openBot(){w.classList.remove('d-none');if(!m.dataset.greeted){add('bot','Hi! I\'m here to help with applications, documents, fees, and tracking.');buildChips();m.dataset.greeted='1'}}
   function closeBot(){w.classList.add('d-none')}
   function send(txt){var q=typeof txt==='string'?txt:i.value;if(!q||!q.trim())return;add('user',q.trim());i.value='';setTimeout(function(){add('bot',answer(q))},200)}
   t.addEventListener('click',function(){if(w.classList.contains('d-none'))openBot();else closeBot()});
   x.addEventListener('click',closeBot);
   s.addEventListener('click',function(){send()});
   i.addEventListener('keydown',function(e){if(e.key==='Enter'){e.preventDefault();send()}});
 })();
 </script>
 </body></html>
