<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
$tracking = trim($_GET['tracking'] ?? '');
$app = $tracking ? db_fetch('SELECT * FROM applications WHERE tracking_no=?',[$tracking]) : null;
if(!$app){ http_response_code(404); echo 'Invalid tracking'; exit; }
$approved = $app['status']==='APPROVED';
$approvedAt = null;
if ($approved){
  $row = db_fetch("SELECT created_at FROM status_history WHERE app_id=? AND status='APPROVED' ORDER BY id DESC LIMIT 1",[$app['id']]);
  $approvedAt = $row['created_at'] ?? $app['created_at'];
}
$extra = json_decode($app['extra_json'] ?? '{}', true) ?: [];
$company = $extra['company_details'] ?? [];
$activity = trim($company['activity'] ?? '');
if ($activity==='') $activity = 'GENERAL COMMERCIAL ACTIVITIES';
$directors = $extra['directors'] ?? [];
$shares_registered = 100000; // default prototype value
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Regulations - <?php echo e($app['company_name']) ?></title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body{background:#f8f9fa}
    .doc{background:#fff;border:1px solid #dee2e6;border-radius:8px;box-shadow:0 0.5rem 1rem rgba(0,0,0,.05)}
    .watermark{position:absolute;inset:0;display:flex;align-items:center;justify-content:center;pointer-events:none;opacity:.05;font-size:140px;font-weight:800;letter-spacing:6px;transform: rotate(-22deg)}
    .crest{width:60px;height:60px;border-radius:50%;background:#222;margin-right:10px}
    .serif{font-family: Georgia, 'Times New Roman', Times, serif}
    ol.regulations{counter-reset:item}
    ol.regulations>li{margin-bottom:14px}
    table.small td,table.small th{padding:.35rem}
    @media print{.noprint{display:none}}
  </style>
</head>
<body>
<div class="container py-4">
  <div class="d-flex justify-content-between mb-3 noprint">
    <a class="btn btn-outline-secondary" href="track.php?tracking=<?php echo urlencode($app['tracking_no']) ?>">Back</a>
    <button class="btn btn-primary" onclick="window.print()">Print</button>
  </div>
  <div class="position-relative p-4 doc">
    <div class="watermark">TRUE COPY</div>
    <div class="text-center mb-3">
      <span class="crest"></span>
      <div class="d-inline-block text-start align-middle">
        <div class="h6 mb-0 serif">THE COMPANIES ACT 1963 (ACT 179)</div>
        <div class="h5 mb-0 serif">REGULATIONS OF A PRIVATE COMPANY LIMITED BY SHARES</div>
      </div>
    </div>

    <?php if(!$approved): ?>
      <div class="alert alert-warning">This application is not yet approved. Regulations will be available after approval.</div>
    <?php else: ?>
      <ol class="regulations">
        <li><strong>The name of the Company is</strong> <span class="text-uppercase fw-semibold"><?php echo e($app['company_name']) ?></span>.</li>
        <li>
          <strong>The nature of the business which the Company is authorized to carry on are:</strong>
          <div class="mt-1"><?php echo nl2br(e($activity)) ?></div>
        </li>
        <li>
          Pursuant to section 24 of the Companies Act, 1963 (Act 179) the company has for the furtherance of its authorized businesses all the powers of a natural person of full capacity.
        </li>
        <li>
          <strong>The first director(s) of the company are:</strong>
          <div class="table-responsive mt-2">
            <table class="table table-sm table-bordered small w-auto">
              <thead class="table-light"><tr><th style="min-width:150px">TIN/ID</th><th style="min-width:260px">Name</th></tr></thead>
              <tbody>
              <?php foreach($directors as $d): ?>
                <tr><td><?php echo e($d['id'] ?? '') ?></td><td class="text-uppercase"><?php echo e($d['name'] ?? '') ?></td></tr>
              <?php endforeach; if(empty($directors)): ?>
                <tr><td colspan="2" class="text-muted">Not provided</td></tr>
              <?php endif; ?>
              </tbody>
            </table>
          </div>
        </li>
        <li>The powers of the board of directors are limited in accordance with Section 202 of the Act.</li>
        <li>The liability of the members of the Company is limited.</li>
        <li>The Company is to be registered with <strong><?php echo number_format($shares_registered) ?></strong> shares of no par value.</li>
        <li>
          <strong>The company is a private company and accordingly:</strong>
          <div class="ms-3 mt-2">
            <div>(a) the right to transfer shares is restricted at the discretion of the directors;</div>
            <div>(b) the number of members of the company (exclusive of employees) is limited to fifty;</div>
            <div>(c) the company is prohibited from making any invitation to the public to acquire shares or debentures.</div>
          </div>
        </li>
      </ol>

      <h5 class="mt-4">Shares and Variation of Rights</h5>
      <ol class="regulations mt-2">
        <li>
          The company may, by special resolution altering these Regulations:
          <div class="ms-3 mt-2">
            <div>(a) increase the number of its shares by creating new shares;</div>
            <div>(b) reduce the number of its shares;</div>
            <div>(c) provide for different classes of shares with special rights or restrictions;</div>
            <div>(d) subject to the Act, create preference shares which are liable to be redeemed on such terms as may be provided.</div>
          </div>
        </li>
        <li>The company shall not issue any new or unissued shares for cash unless first offered to existing shareholders in proportion to their holdings.</li>
        <li>This regulation shall not be alterable except with the unanimous consent of all the members of the company.</li>
        <li>If at any time the shares are divided into different classes, the rights attached may be varied with the written consent of holders of three-fourths of the issued shares of that class or with the sanction of a special resolution of the holders of that class.</li>
        <li>Subject to sections 60 to 63 of the Act the company may purchase, acquire, or forfeit its own shares as permitted by the Act.</li>
        <li>The company may pay commission or brokerage for subscriptions of any shares provided the payment does not exceed ten per centum of the price at which shares are issued.</li>
        <li>Share certificates shall be issued in accordance with section 53 of the Act.</li>
      </ol>

      <div class="mt-5">
        <div class="text-muted small">Date of Registration</div>
        <div class="fw-semibold"><?php echo e($approvedAt) ?></div>
      </div>
    <?php endif; ?>
  </div>
</div>
</body>
</html>
