<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
require_once __DIR__ . '/../lib/config.php';
require_once __DIR__ . '/../lib/notify.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
$brand = brand();
$q = trim($_GET['q'] ?? '');
$sel = trim($_GET['sel'] ?? '');
$app = null; $apps = [];
$otp_err = ''; $otp_ok = ''; $last4_err = '';
$tracking = '';

// If a specific app choice was selected
if ($sel !== '') {
  $app = db_fetch('SELECT * FROM applications WHERE id=? AND status=?', [(int)$sel, 'APPROVED']);
  if ($app) { $tracking = $app['tracking_no']; }
}

// Search by query when provided
if (!$app && $q !== ''){
  $needle = $q;
  $is_cert = stripos($needle, 'CERT-') === 0;
  $is_track = stripos($needle, 'RGD-') === 0;
  if ($is_cert) {
    $suffix = substr($needle, 5);
    $apps = db_fetch_all("SELECT * FROM applications WHERE status='APPROVED' AND tracking_no LIKE ? ORDER BY created_at DESC", ['%'.trim($suffix)]);
  } elseif ($is_track) {
    $apps = db_fetch_all("SELECT * FROM applications WHERE status='APPROVED' AND tracking_no=?", [$needle]);
  } else {
    // Try companies table (registration number) if present
    try {
      $tbl = db_fetch("SELECT name FROM sqlite_master WHERE type='table' AND name='companies'");
      if ($tbl && !empty($tbl['name'])){
        // Prefer exact registration number match
        try{
          $apps = db_fetch_all("SELECT a.* FROM companies c JOIN applications a ON a.id=c.app_id WHERE c.registration_no=? AND a.status='APPROVED'", [$needle]);
        } catch (Exception $e){ $apps = []; }
        if (!$apps){
          try{
            $apps = db_fetch_all("SELECT a.* FROM companies c JOIN applications a ON a.tracking_no=c.tracking_no WHERE c.registration_no=? AND a.status='APPROVED'", [$needle]);
          } catch (Exception $e){ $apps = []; }
        }
        if (!$apps){
          // Fallback LIKE on company name across applications
          $apps = db_fetch_all("SELECT * FROM applications WHERE status='APPROVED' AND company_name LIKE ? ORDER BY created_at DESC", ['%'.$needle.'%']);
        }
      } else {
        $apps = db_fetch_all("SELECT * FROM applications WHERE status='APPROVED' AND company_name LIKE ? ORDER BY created_at DESC", ['%'.$needle.'%']);
      }
    } catch (Exception $e) {
      $apps = db_fetch_all("SELECT * FROM applications WHERE status='APPROVED' AND company_name LIKE ? ORDER BY created_at DESC", ['%'.$needle.'%']);
    }
  }
  if (count($apps) === 1) { $app = $apps[0]; $tracking = $app['tracking_no']; }
}

$verified = $tracking ? (bool)(($_SESSION['otp'][$tracking]['verified'] ?? false) && ($_SESSION['otp'][$tracking]['last4_ok'] ?? false)) : false;
$masked_phone = ($app && !empty($app['phone'])) ? (substr($app['phone'],0,3).'****'.substr($app['phone'],-2)) : '';

if ($_SERVER['REQUEST_METHOD']==='POST'){
  $action = $_POST['action'] ?? '';
  $tracking = trim($_POST['tracking'] ?? '');
  $app = $tracking ? db_fetch('SELECT * FROM applications WHERE tracking_no=? AND status=?',[$tracking,'APPROVED']) : null;
  if ($app){ if (!isset($_SESSION['otp'])) $_SESSION['otp']=[]; $otp = $_SESSION['otp'][$tracking] ?? []; }

  if ($action==='request_otp' && $app){
    if (empty($app['phone'])){ $otp_err = 'No phone number on file for this company.'; }
    else {
      $now = time();
      if (isset($otp['last_sent']) && ($now - (int)$otp['last_sent']) < 30) { $otp_err = 'Please wait a few seconds before requesting another code.'; }
      else {
        $code = str_pad((string)random_int(0,999999),6,'0',STR_PAD_LEFT);
        $otp = ['code'=>$code,'expires'=>$now+300,'last_sent'=>$now,'verified'=>false,'last4_ok'=>false];
        $_SESSION['otp'][$tracking] = $otp;
        notify_sms($app['phone'], 'RGD OTP: '.$code.' (valid 5 minutes) for '.$app['company_name']);
        $otp_ok = 'OTP sent to '.$masked_phone;
      }
    }
  } elseif ($action==='verify_otp' && $app){
    $code = trim($_POST['otp_code'] ?? '');
    $last4 = trim($_POST['last4'] ?? '');
    $now = time();
    // Rate limit last-4 attempts
    if (!empty($otp['last4_locked_until']) && $now < (int)$otp['last4_locked_until']){
      $remain = (int)$otp['last4_locked_until'] - $now;
      $last4_err = 'Too many attempts. Try again in '.ceil($remain/60).' minute(s).';
    } elseif (!$otp || empty($otp['code'])) { $otp_err = 'Please request a code first.'; }
    elseif ((int)($otp['expires'] ?? 0) < time()) { $otp_err = 'Code expired. Request a new code.'; }
    elseif (!hash_equals((string)$otp['code'], (string)$code)) { $otp_err = 'Invalid code.'; }
    else {
      // Validate last 4 against any director/shareholder ID/TIN in extra_json
      $extra = json_decode($app['extra_json'] ?? '{}', true) ?: [];
      $ok = false;
      foreach (['directors','owners'] as $group){
        foreach (($extra[$group] ?? []) as $p){
          $id = trim((string)($p['id'] ?? ''));
          if ($id !== '' && strlen($id) >= 4 && substr($id,-4) === $last4){ $ok = true; break 2; }
        }
      }
      if ($ok){
        $otp['verified'] = true; $otp['last4_ok'] = true;
        $otp['last4_try_count'] = 0; $otp['last4_locked_until'] = 0; $otp['last4_window_start'] = $now;
        $_SESSION['otp'][$tracking] = $otp; $verified = true; $otp_ok = 'Verification successful.';
      } else {
        // Increment attempts within a rolling 15-min window
        $win = (int)($otp['last4_window_start'] ?? $now);
        if (($now - $win) > 900){ $otp['last4_window_start'] = $now; $otp['last4_try_count'] = 0; }
        $otp['last4_try_count'] = (int)($otp['last4_try_count'] ?? 0) + 1;
        if ($otp['last4_try_count'] >= 5){
          $otp['last4_locked_until'] = $now + 300; // 5-minute lock
          $last4_err = 'Too many attempts. Try again in 5 minute(s).';
        } else {
          $last4_err = 'The last 4 digits do not match our records.';
        }
        $_SESSION['otp'][$tracking] = $otp;
      }
    }
  }
}

$docs = [];
if ($app && $verified){
  $docs = db_fetch_all('SELECT * FROM app_docs WHERE app_id=? ORDER BY id DESC',[$app['id']]);
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Retrieve Company Documents</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-dark" style="background: <?php echo e($brand['color']) ?>"><div class="container">
  <a class="navbar-brand d-flex align-items-center" href="index.php">
    <?php if($brand['logo']): ?><img src="<?php echo e(brand_logo_src()) ?>" alt="Logo" style="height:28px" class="me-2"><?php endif; ?>
    <?php echo e($brand['name']) ?> — Public Portal
  </a>
</div></nav>
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-9">
      <div class="mb-4 d-flex justify-content-between align-items-center">
        <div>
          <a href="index.php" class="link-secondary">Back</a>
          <h2 class="fw-bold mt-2">Retrieve Company Documents</h2>
        </div>
        <form class="d-flex" method="get">
          <input name="q" value="<?php echo e($q) ?>" class="form-control" placeholder="Company name or CERT-...">
          <button class="btn btn-outline-secondary ms-2" type="submit">Search</button>
        </form>
      </div>

      <?php if(!$app && !$apps): ?>
        <?php if($q!==''): ?><div class="alert alert-warning">No approved company found for that query.</div><?php endif; ?>
      <?php elseif(!$app && $apps): ?>
        <div class="card shadow-sm">
          <div class="card-body">
            <div class="h6 mb-2">Select a company</div>
            <ul class="list-group list-group-flush">
              <?php foreach($apps as $x): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                  <div>
                    <div class="fw-semibold"><?php echo e($x['company_name']) ?></div>
                    <div class="small text-muted">Tracking: <code><?php echo e($x['tracking_no']) ?></code> • Type: <?php echo e(company_types()[$x['company_type']] ?? $x['company_type']) ?></div>
                  </div>
                  <a class="btn btn-outline-primary" href="retrieve.php?sel=<?php echo urlencode($x['id']) ?>">Get documents</a>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>
        </div>
      <?php elseif($app && !$verified): ?>
        <div class="card shadow-sm mb-4">
          <div class="card-body">
            <div class="h5 mb-2"><?php echo e($app['company_name']) ?></div>
            <div class="text-muted small mb-2">Verify with OTP and last 4 digits of a Director/Shareholder TIN/ID on file. OTP will be sent to <?php echo e($masked_phone) ?>.</div>
            <?php if($otp_err): ?><div class="alert alert-danger py-2 mb-2"><?php echo e($otp_err) ?></div><?php endif; ?>
            <?php if($otp_ok): ?><div class="alert alert-success py-2 mb-2"><?php echo e($otp_ok) ?></div><?php endif; ?>
            <?php if($last4_err): ?><div class="alert alert-danger py-2 mb-2"><?php echo e($last4_err) ?></div><?php endif; ?>
            <form class="row g-2" method="post">
              <input type="hidden" name="tracking" value="<?php echo e($app['tracking_no']) ?>">
              <input type="hidden" name="action" value="request_otp">
              <div class="col-12 col-md-4">
                <button class="btn btn-outline-primary w-100" type="submit">Send Code</button>
              </div>
            </form>
            <form class="row g-2 align-items-end mt-2" method="post">
              <input type="hidden" name="tracking" value="<?php echo e($app['tracking_no']) ?>">
              <input type="hidden" name="action" value="verify_otp">
              <div class="col-12 col-md-4">
                <label class="form-label small">Enter 6-digit code</label>
                <input name="otp_code" class="form-control" maxlength="6" placeholder="123456" required>
              </div>
              <div class="col-12 col-md-4">
                <label class="form-label small">Last 4 digits (TIN/Ghana Card of Director or Shareholder)</label>
                <input name="last4" class="form-control" maxlength="4" placeholder="1234" required>
              </div>
              <div class="col-12 col-md-4">
                <button class="btn btn-success w-100" type="submit">Verify</button>
              </div>
            </form>
          </div>
        </div>
      <?php elseif($app && $verified): ?>
        <div class="card shadow-sm mb-4">
          <div class="card-body">
            <div class="h6 mb-2">Company</div>
            <div class="d-flex flex-wrap gap-3">
              <div>Tracking: <code><?php echo e($app['tracking_no']) ?></code></div>
              <div>Name: <strong><?php echo e($app['company_name']) ?></strong></div>
              <div>Status: <span class="badge bg-success">APPROVED</span></div>
            </div>
            <div class="mt-3 d-flex flex-wrap gap-2">
              <a class="btn btn-success" target="_blank" href="certificate.php?tracking=<?php echo urlencode($app['tracking_no']) ?>">View Certificate</a>
              <a class="btn btn-outline-primary" target="_blank" href="regulations.php?tracking=<?php echo urlencode($app['tracking_no']) ?>">View Regulations</a>
              <a class="btn btn-outline-primary" target="_blank" href="form3.php?tracking=<?php echo urlencode($app['tracking_no']) ?>">View Form 3</a>
            </div>
          </div>
        </div>
        <div class="card shadow-sm">
          <div class="card-body">
            <div class="h6 mb-2">Uploaded documents</div>
            <?php if(!$docs): ?><div class="text-muted">No uploaded documents found.</div><?php endif; ?>
            <ul class="list-group list-group-flush">
              <?php foreach($docs as $d): $lbl = doc_labels()[$d['doc_key']] ?? $d['doc_key']; $exp = time()+600; $sig = hash_hmac('sha256', $app['tracking_no'].'|'.$d['id'].'|'.$exp, (string)config_get('download_secret','change-me')); ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                  <div>
                    <div class="fw-semibold"><?php echo e($lbl) ?></div>
                    <div class="small text-muted"><?php echo e($d['uploaded_at']) ?></div>
                  </div>
                  <a class="btn btn-outline-secondary" target="_blank" href="download.php?tracking=<?php echo urlencode($app['tracking_no']) ?>&id=<?php echo urlencode($d['id']) ?>&exp=<?php echo $exp ?>&sig=<?php echo urlencode($sig) ?>">Download</a>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>
        </div>
      <?php endif; ?>

      <div class="text-center mt-4"><a href="index.php" class="link-secondary">Back to Public Portal</a></div>
    </div>
  </div>
</div>
</body>
</html>
