<?php
// Simple reverse geocoding proxy using OpenStreetMap Nominatim
// Returns JSON with at least display_name on success, or a fallback on failure.

header('Content-Type: application/json; charset=utf-8');

$lat = isset($_GET['lat']) ? (float)$_GET['lat'] : null;
$lng = isset($_GET['lng']) ? (float)$_GET['lng'] : null;
if ($lat === null || $lng === null) {
  http_response_code(400);
  echo json_encode(['error' => 'Missing lat/lng']);
  exit;
}

$url = 'https://nominatim.openstreetmap.org/reverse?format=jsonv2&lat=' . rawurlencode((string)$lat) . '&lon=' . rawurlencode((string)$lng) . '&zoom=16&addressdetails=1';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
// Respect Nominatim policy: provide an identifiable User-Agent
curl_setopt($ch, CURLOPT_USERAGENT, 'RGD-Prototype/1.0 (+http://localhost/orc-app/rgd-prototype)');
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Accept: application/json']);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$error = curl_error($ch);
$http = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($error || !$response || $http >= 400) {
  echo json_encode([
    'display_name' => $lat . ',' . $lng,
    'error' => $error ?: ('HTTP ' . $http)
  ]);
  exit;
}

echo $response;
