<?php
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/util.php';
require_once __DIR__ . '/../lib/workflow.php';
require_once __DIR__ . '/../lib/notify.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
$tracking = trim($_POST['tracking'] ?? ($_GET['tracking'] ?? ''));
$app = $tracking ? db_fetch('SELECT * FROM applications WHERE tracking_no=?',[$tracking]) : null;
$otp_err = '';
$otp_ok = '';
$verified = $app ? (bool)(($_SESSION['otp'][$tracking]['verified'] ?? false)) : false;
$masked_phone = ($app && !empty($app['phone'])) ? (substr($app['phone'],0,3).'****'.substr($app['phone'],-2)) : '';
if ($_SERVER['REQUEST_METHOD'] === 'POST'){
  $action = $_POST['action'] ?? '';
  if ($app) {
    if (!isset($_SESSION['otp'])) { $_SESSION['otp'] = []; }
    $otp = $_SESSION['otp'][$tracking] ?? [];
  }
  if ($action === 'request_otp' && $app) {
    if (empty($app['phone'])) {
      $otp_err = 'No phone number on file for this application.';
    } else {
      $now = time();
      if (isset($otp['last_sent']) && ($now - (int)$otp['last_sent']) < 30) {
        $otp_err = 'Please wait a few seconds before requesting another code.';
      } else {
        $code = str_pad((string)random_int(0,999999),6,'0',STR_PAD_LEFT);
        $otp = ['code'=>$code,'expires'=>$now+300,'last_sent'=>$now,'verified'=>false];
        $_SESSION['otp'][$tracking] = $otp;
        notify_sms($app['phone'], 'RGD OTP: '.$code.' (valid 5 minutes). Tracking '.$app['tracking_no']);
        $otp_ok = 'OTP sent to '.$masked_phone;
      }
    }
  } elseif ($action === 'verify_otp' && $app) {
    $code = trim($_POST['otp_code'] ?? '');
    if (!$otp || empty($otp['code'])) {
      $otp_err = 'Please request a code first.';
    } elseif ((int)($otp['expires'] ?? 0) < time()) {
      $otp_err = 'Code expired. Request a new code.';
    } elseif (hash_equals((string)$otp['code'], (string)$code)) {
      $otp['verified'] = true;
      $_SESSION['otp'][$tracking] = $otp;
      $verified = true;
      $otp_ok = 'Verification successful.';
    } else {
      $otp_err = 'Invalid code.';
    }
  } elseif ($action === 'resend_otp' && $app) {
    $now = time();
    if (empty($app['phone'])) {
      $otp_err = 'No phone number on file for this application.';
    } elseif (isset($otp['last_sent']) && ($now - (int)$otp['last_sent']) < 30) {
      $otp_err = 'Please wait a few seconds before requesting another code.';
    } else {
      $code = str_pad((string)random_int(0,999999),6,'0',STR_PAD_LEFT);
      $otp = ['code'=>$code,'expires'=>$now+300,'last_sent'=>$now,'verified'=>false];
      $_SESSION['otp'][$tracking] = $otp;
      notify_sms($app['phone'], 'RGD OTP: '.$code.' (valid 5 minutes). Tracking '.$app['tracking_no']);
      $otp_ok = 'A new code was sent to '.$masked_phone;
    }
  } elseif ($action === 'send_reply' && $app) {
    if ($verified) {
      $reply = trim($_POST['reply_body'] ?? '');
      if ($reply !== ''){
        add_message($app['id'],'IN','Applicant Reply',$reply,null);
        add_status($app['id'],$app['status'],'Applicant replied to message',null);
        header('Location: track.php?tracking='.urlencode($tracking));
        exit;
      }
    } else {
      $otp_err = 'Please verify the OTP to send messages.';
    }
  }
}
$history = $app ? db_fetch_all('SELECT * FROM status_history WHERE app_id=? ORDER BY id ASC',[$app['id']]) : [];
$msgs = $app ? db_fetch_all('SELECT * FROM messages WHERE app_id=? ORDER BY id DESC',[$app['id']]) : [];
$paid = $app ? (bool)db_fetch('SELECT id FROM payments WHERE app_id=? AND status=? LIMIT 1',[$app['id'],'PAID']) : false;
$brand = brand();
?><!doctype html><html><head><meta charset="utf-8"><title>Track Application</title><meta name="viewport" content="width=device-width,initial-scale=1"><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"><style>:root{--brand: <?php echo e($brand['color']) ?>}
  .gh-flag{display:flex;height:4px}
  .gh-flag span{flex:1}
  .gh-flag .red{background:#ce1126}
  .gh-flag .gold{background:#fcd116}
  .gh-flag .green{background:#006b3f}
</style></head><body class="bg-light">
<nav class="navbar navbar-dark" style="background: var(--brand)"><div class="container">
  <a class="navbar-brand d-flex align-items-center" href="index.php">
    <?php if($brand['logo']): ?><img src="<?php echo e(brand_logo_src()) ?>" alt="Logo" style="height:28px" class="me-2"><?php endif; ?>
    <?php echo e($brand['name']) ?> — Public Portal
  </a>
</div></nav>
<div class="gh-flag"><span class="red"></span><span class="gold"></span><span class="green"></span></div>
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-9">
      <div class="mb-4 d-flex justify-content-between align-items-center">
        <div>
          <a href="index.php" class="link-secondary">Back</a>
          <h2 class="fw-bold mt-2">Application Tracking</h2>
        </div>
        <form class="d-flex" method="get">
          <input name="tracking" value="<?php echo e($tracking) ?>" class="form-control" placeholder="Enter tracking">
          <button class="btn btn-outline-secondary ms-2" type="submit">Search</button>
        </form>
      </div>

      <?php if(!$app): ?>
        <div class="alert alert-warning">Enter a valid tracking number.</div>
      <?php else: ?>
      <?php if(!$verified): ?>
        <div class="card shadow-sm mb-4">
          <div class="card-body">
            <div class="h5 mb-2">Verify your identity</div>
            <div class="text-muted small mb-2">For your privacy, please verify with the OTP sent to your phone ending <?php echo e($masked_phone) ?>.</div>
            <?php if($otp_err): ?><div class="alert alert-danger py-2 mb-2"><?php echo e($otp_err) ?></div><?php endif; ?>
            <?php if($otp_ok): ?><div class="alert alert-success py-2 mb-2"><?php echo e($otp_ok) ?></div><?php endif; ?>
            <form class="row g-2" method="post">
              <input type="hidden" name="tracking" value="<?php echo e($tracking) ?>">
              <input type="hidden" name="action" value="request_otp">
              <div class="col-12 col-md-4">
                <button class="btn btn-outline-primary w-100" type="submit">Send Code</button>
              </div>
            </form>
            <form class="row g-2 align-items-end mt-2" method="post">
              <input type="hidden" name="tracking" value="<?php echo e($tracking) ?>">
              <input type="hidden" name="action" value="verify_otp">
              <div class="col-8">
                <label class="form-label small">Enter 6-digit code</label>
                <input name="otp_code" class="form-control" maxlength="6" placeholder="123456" required>
              </div>
              <div class="col-4">
                <button class="btn btn-success w-100" type="submit">Verify</button>
              </div>
            </form>
            <form class="mt-2" method="post">
              <input type="hidden" name="tracking" value="<?php echo e($tracking) ?>">
              <input type="hidden" name="action" value="resend_otp">
              <button class="btn btn-link p-0 small" type="submit">Resend code</button>
            </form>
          </div>
        </div>
      <?php else: ?>
      <div class="card shadow-sm mb-4">
        <div class="card-body">
          <div class="d-flex justify-content-between flex-wrap">
            <div>
              <div class="text-muted">Tracking</div>
              <div class="h5"><code><?php echo e($app['tracking_no']) ?></code></div>
            </div>
            <div>
              <div class="text-muted">Company</div>
              <div class="h5"><?php echo e($app['company_name']) ?> (<?php echo e(company_types()[$app['company_type']] ?? $app['company_type']) ?>)</div>
            </div>
            <div>
              <div class="text-muted">Status</div>
              <div class="h5"><?php echo e(statuses()[$app['status']] ?? $app['status']) ?></div>
            </div>
          </div>
          <?php if($app['status']==='APPROVED'): ?>
            <div class="d-flex flex-wrap gap-2 mt-3">
              <a class="btn btn-success" target="_blank" href="certificate.php?tracking=<?php echo urlencode($app['tracking_no']) ?>">View Certificate</a>
              <a class="btn btn-outline-primary" target="_blank" href="regulations.php?tracking=<?php echo urlencode($app['tracking_no']) ?>">View Regulations</a>
              <a class="btn btn-outline-primary" target="_blank" href="form3.php?tracking=<?php echo urlencode($app['tracking_no']) ?>">View Form 3</a>
            </div>
          <?php endif; ?>
          <?php if(in_array($app['status'],['FOR_AUTHORIZATION','AUTHORIZED'])): ?>
            <?php if($paid): ?>
              <div class="alert alert-success mt-3">Payment received. Your application is being processed.</div>
            <?php else: ?>
              <div class="alert alert-info mt-3">Your application is awaiting authorization.</div>
            <?php endif; ?>
          <?php endif; ?>
        </div>
      </div>

      <div class="row g-4">
        <div class="col-md-6">
          <div class="card shadow-sm h-100">
            <div class="card-body">
              <div class="h5 mb-3">Status Timeline</div>
              <ul class="list-group list-group-flush">
                <?php foreach($history as $h): ?>
                  <li class="list-group-item">
                    <div class="fw-semibold"><?php echo e(statuses()[$h['status']] ?? $h['status']) ?></div>
                    <div class="small text-muted"><?php echo e($h['created_at']) ?></div>
                    <?php if($h['note']): ?><div class="small"><?php echo e($h['note']) ?></div><?php endif; ?>
                  </li>
                <?php endforeach; ?>
              </ul>
            </div>
          </div>
        </div>
        <div class="col-md-6">
          <div class="card shadow-sm h-100">
            <div class="card-body">
              <div class="h5 mb-3">Messages</div>
              <?php if(!$msgs): ?><div class="text-muted">No messages yet.</div><?php endif; ?>
              <?php foreach($msgs as $m): ?>
                <div class="border rounded p-2 mb-2">
                  <div class="d-flex justify-content-between">
                    <div class="fw-semibold"><?php echo e($m['subject']) ?></div>
                    <div class="small text-muted"><?php echo e($m['created_at']) ?></div>
                  </div>
                  <div class="small text-muted"><?php echo e($m['direction']==='OUT'?'From RGD':'From You') ?></div>
                  <div><?php echo nl2br(e($m['body'])) ?></div>
                </div>
              <?php endforeach; ?>
              <form method="post" class="mt-3">
                <input type="hidden" name="tracking" value="<?php echo e($tracking) ?>">
                <input type="hidden" name="action" value="send_reply">
                <div class="mb-2">
                  <label class="form-label">Send a message to RGD</label>
                  <textarea name="reply_body" class="form-control" rows="3" placeholder="Type your reply or provide requested information" required></textarea>
                </div>
                <button class="btn btn-outline-primary">Send</button>
              </form>
            </div>
          </div>
        </div>
      </div>
      <?php endif; ?>
      <?php endif; ?>

      <div class="text-center mt-4"><a href="index.php" class="link-secondary">Back to Public Portal</a></div>
    </div>
  </div>
</div>
</body></html>
